/*
 * Decompiled with CFR 0.152.
 */
package net.arcadiusmc.dom;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.arcadiusmc.dom.DomQueryable;
import net.arcadiusmc.dom.Node;
import net.arcadiusmc.dom.TextNode;
import net.arcadiusmc.dom.event.EventTarget;
import net.arcadiusmc.dom.style.StyleProperties;
import net.arcadiusmc.dom.style.StylePropertiesReadonly;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Element
extends Node,
EventTarget,
DomQueryable {
    public StyleProperties getInlineStyle();

    public StylePropertiesReadonly getCurrentStyle();

    @Nullable
    public String getAttribute(String var1);

    public void setAttribute(@NotNull String var1, @Nullable String var2);

    public Set<String> getAttributeNames();

    public Set<Map.Entry<String, String>> getAttributeEntries();

    default public String getId() {
        return this.getAttribute("id");
    }

    default public void setId(@Nullable String elementId) {
        this.setAttribute("id", elementId);
    }

    @Nullable
    default public String getClassName() {
        return this.getAttribute("class");
    }

    default public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @NotNull
    default public List<String> getClassList() {
        String str = this.getClassName();
        if (Strings.isNullOrEmpty((String)str)) {
            return new ArrayList<String>();
        }
        String[] split = str.split("\\s+");
        ArrayList<String> stringList = new ArrayList<String>();
        Collections.addAll(stringList, split);
        return stringList;
    }

    default public void setClassList(@Nullable Collection<String> classList) {
        if (classList == null) {
            this.setAttribute("class", null);
            return;
        }
        StringJoiner joiner = new StringJoiner(" ");
        for (String s : classList) {
            joiner.add(s);
        }
        this.setAttribute("class", joiner.toString());
    }

    public String getTagName();

    @Nullable
    public Node getTooltip();

    @Nullable
    public Node getTitleNode();

    public void setTitleNode(@Nullable Node var1);

    public void appendChild(@NotNull Node var1);

    public void prependChild(@NotNull Node var1);

    public void insertBefore(@NotNull Node var1, @NotNull Node var2);

    public void insertAfter(@NotNull Node var1, @NotNull Node var2);

    public boolean removeChild(@NotNull Node var1);

    public void removeChild(int var1) throws IndexOutOfBoundsException;

    public List<Node> getChildren();

    public boolean hasChildren();

    @Contract(value="null -> false")
    public boolean hasChild(@Nullable Node var1);

    public int indexOf(@Nullable Node var1);

    public int getChildCount();

    public boolean canHaveChildren();

    public Node getChild(int var1) throws IndexOutOfBoundsException;

    @Nullable
    public Node firstChild();

    @Nullable
    public Node lastChild();

    @NotNull
    default public Element appendElement(@NotNull String tagName) {
        Element el = this.getOwningDocument().createElement(tagName);
        this.appendChild(el);
        return el;
    }

    @NotNull
    default public TextNode appendText(@Nullable String text) {
        TextNode node = this.getOwningDocument().createText(text);
        this.appendChild(node);
        return node;
    }

    public String getTextContent();

    public void setTextContent(String var1);

    public void forEachDescendant(@NotNull Consumer<Node> var1);
}

