/*
 * Decompiled with CFR 0.152.
 */
package net.arcadiusmc.delphi.util;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.arcadiusmc.delphi.resource.DelphiException;
import net.arcadiusmc.delphi.util.Err;
import net.arcadiusmc.delphi.util.Nothing;
import net.arcadiusmc.delphi.util.Ok;
import net.arcadiusmc.delphi.util.ResultException;
import org.jetbrains.annotations.Nullable;

public sealed interface Result<T, E>
permits Err, Ok {
    public static <T, E> Result<T, E> err(E err) {
        Objects.requireNonNull(err, "Null error value");
        return new Err(err);
    }

    public static <T1, T2, E> Result<T2, E> err(Result<T1, E> res) {
        Objects.requireNonNull(res, "Null result");
        if (!res.isError()) {
            throw new IllegalArgumentException("result is not an error");
        }
        return res;
    }

    public static <T> Result<T, String> formatted(String string, Object ... args) {
        return Result.err(String.format(string, args));
    }

    public static <T, E> Result<T, E> ok(T value) {
        Objects.requireNonNull(value, "Null result value");
        return new Ok(value);
    }

    public static <T> Result<T, DelphiException> ioError(IOException exc) {
        if (exc instanceof NoSuchFileException) {
            NoSuchFileException no = (NoSuchFileException)exc;
            return Result.err(new DelphiException(1, no.getFile(), no));
        }
        if (exc instanceof AccessDeniedException) {
            AccessDeniedException acc = (AccessDeniedException)exc;
            return Result.err(new DelphiException(2, (Throwable)acc));
        }
        return Result.err(new DelphiException(3, (Throwable)exc));
    }

    public static <E> Result<Nothing, E> nothing() {
        return Ok.NOTHING;
    }

    public Optional<T> value();

    public Optional<E> error();

    public <T2> Result<T2, E> map(Function<T, T2> var1);

    public <T2> Result<T2, E> flatMap(Function<T, Result<T2, E>> var1);

    public <E2> Result<T, E2> mapError(Function<E, E2> var1);

    public boolean isError();

    public boolean isSuccess();

    public Result<T, E> ifError(Consumer<E> var1);

    public Result<T, E> ifSuccess(Consumer<T> var1);

    public T getOrThrow() throws ResultException;

    public <X extends Exception> T getOrThrow(Function<E, X> var1) throws X;

    public T orElse(@Nullable T var1);

    public T orElseGet(Supplier<T> var1);
}

