/*
 * Decompiled with CFR 0.152.
 */
package net.arcadiusmc.dom.style;

import net.arcadiusmc.dom.style.DelphiColor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public sealed interface Color
permits DelphiColor {
    public static final int MASK = 255;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 255;

    public static Color rgb(int red, int green, int blue) throws IllegalArgumentException {
        return Color.argb(255, red, green, blue);
    }

    public static Color rgb(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        return Color.rgb(r, g, b);
    }

    public static Color argb(int alpha, int red, int green, int blue) throws IllegalArgumentException {
        return new DelphiColor(alpha, red, green, blue);
    }

    public static Color argb(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb >> 0 & 0xFF;
        return Color.argb(a, r, g, b);
    }

    public static Color hsv(float hue, float saturation, float value) {
        return Color.hsva(hue, saturation, value, 1.0f);
    }

    public static Color hsva(float hue, float saturation, float value, float alpha) {
        return DelphiColor.hsvaColor(hue, saturation, value, alpha);
    }

    @Contract(value="_, null -> null")
    public static Color lerpRgb(float progress, Color ... colors) {
        return DelphiColor.blend(false, progress, colors);
    }

    public static Color lerpHsv(float progress, Color ... colors) {
        return DelphiColor.blend(true, progress, colors);
    }

    public @Range(from=0L, to=255L) int getAlpha();

    public @Range(from=0L, to=255L) int getRed();

    public @Range(from=0L, to=255L) int getGreen();

    public @Range(from=0L, to=255L) int getBlue();

    public float @NotNull [] hsv();

    public float @NotNull [] hsva();

    public int argb();

    public int rgb();

    @NotNull
    public Color brighten();

    @NotNull
    public Color brighten(@Range(from=0L, to=1L) float var1);

    @NotNull
    public Color darken();

    @NotNull
    public Color darken(@Range(from=0L, to=1L) float var1);

    @NotNull
    public Color multiplyRgb(float var1);

    @NotNull
    public Color multiplyArgb(float var1);

    @NotNull
    public Color multiplyHsv(float var1);

    @NotNull
    public Color multiplyHsv(float var1, float var2, float var3);

    @NotNull
    public Color blendRgb(@Range(from=0L, to=1L) float var1, @NotNull Color var2);

    @NotNull
    public Color blendHsv(@Range(from=0L, to=1L) float var1, @NotNull Color var2);

    public String toString();
}

