/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.delphi.resource;

import com.juliewoolie.delphi.resource.PathImpl;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ResourcePath
permits PathImpl {
    public static final Pattern VALID_ELEMENT = Pattern.compile("[a-zA-Z0-9 .\\-_$]+");
    public static final Pattern VALID_QUERY = Pattern.compile("[a-zA-Z0-9.\\-_$]+");

    public static ResourcePath create(@NotNull String moduleName) {
        return new PathImpl(moduleName);
    }

    public static void validateFilename(String element) {
        Objects.requireNonNull(element, "Null element");
        if (VALID_ELEMENT.matcher(element).matches()) {
            return;
        }
        throw new IllegalArgumentException("Invalid path element: " + element);
    }

    public static void validateQuery(String query) {
        Objects.requireNonNull(query, "Null query");
        if (VALID_QUERY.matcher(query).matches()) {
            return;
        }
        throw new IllegalArgumentException("Invalid element: " + query);
    }

    @NotNull
    public String getModuleName();

    public ResourcePath setModuleName(@NotNull String var1);

    public ResourcePath addElement(@NotNull String var1);

    public ResourcePath setElement(int var1, @NotNull String var2) throws IndexOutOfBoundsException;

    public ResourcePath setQuery(@NotNull String var1, @Nullable String var2);

    public ResourcePath addAllElements(@NotNull ResourcePath var1);

    public ResourcePath setElements(ResourcePath var1);

    public ResourcePath removeElement(int var1);

    public ResourcePath clearElements();

    @Nullable
    public String getQuery(String var1);

    public Set<String> getQueryKeys();

    public List<String> getElements();

    public int elementCount();

    @NotNull
    public String getElement(int var1) throws IndexOutOfBoundsException;

    @NotNull
    public String path();

    @NotNull
    public String query();

    public String elements();

    public String toString();
}

