/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.delphi.resource;

import com.juliewoolie.delphi.resource.IoModule;
import com.juliewoolie.delphi.resource.ResourcePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarResourceModule
implements IoModule {
    private final ClassLoader loader;
    private final String directory;
    private Charset charset = Charset.defaultCharset();
    private List<String> filePaths = null;

    public JarResourceModule(ClassLoader loader, String directory) {
        this.loader = loader;
        this.directory = directory;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setCharset(@NotNull Charset charset) {
        Objects.requireNonNull(charset, "Null charset");
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Nullable
    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(@Nullable List<String> filePaths) {
        this.filePaths = filePaths;
    }

    private String fqPath(ResourcePath path) {
        if (this.directory.endsWith("/")) {
            return this.directory + path.path();
        }
        return this.directory + "/" + path.path();
    }

    @Override
    @NotNull
    public StringBuffer loadString(@NotNull ResourcePath path) throws IOException {
        String fqPath = this.fqPath(path);
        URL url = this.loader.getResource(fqPath);
        if (url == null) {
            throw new NoSuchFileException(fqPath);
        }
        try (InputStream stream = url.openStream();){
            StringBuffer stringBuffer;
            try (InputStreamReader reader = new InputStreamReader(stream, this.charset);){
                StringWriter writer = new StringWriter();
                reader.transferTo(writer);
                stringBuffer = writer.getBuffer();
            }
            return stringBuffer;
        }
    }

    @Override
    @NotNull
    public Collection<String> getModulePaths(@NotNull ResourcePath pathSoFar) {
        if (this.filePaths == null || this.filePaths.isEmpty()) {
            return List.of();
        }
        String prefix = pathSoFar.path();
        ArrayList<String> stringList = new ArrayList<String>();
        for (String filePath : this.filePaths) {
            if (!filePath.startsWith(prefix)) continue;
            stringList.add(filePath);
        }
        return stringList;
    }
}

