/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.delphi.resource;

import com.google.common.base.Strings;

public class DelphiException
extends RuntimeException {
    public static final int ERR_UNKNOWN = 0;
    public static final int ERR_NO_FILE = 1;
    public static final int ERR_ACCESS_DENIED = 2;
    public static final int ERR_IO_ERROR = 3;
    public static final int ERR_INVALID_PATH = 4;
    public static final int ERR_API_MODULE = 5;
    public static final int ERR_SYNTAX = 6;
    public static final int ERR_SCHEMA_ERROR = 7;
    public static final int ERR_SAX_PARSER_INIT = 8;
    public static final int ERR_DOC_PARSE = 9;
    public static final int ERR_MISSING_PLUGINS = 10;
    public static final int ERR_MODULE_UNKNOWN = 11;
    public static final int ERR_MODULE_DIRECTORY_NOT_FOUND = 12;
    public static final int ERR_MODULE_ZIP_ACCESS_DENIED = 13;
    public static final int ERR_MODULE_ERROR = 14;
    public static final int ERR_EMPTY_MODULE_NAME = 15;
    public static final int ERR_INSTANCE_NAME_USED = 16;
    public static final int ERR_ILLEGAL_INSTANCE_NAME = 17;
    public static final int ERR_OLD_GAME_VERSION = 18;
    private final int code;

    public DelphiException(int code) {
        this.code = code;
    }

    public DelphiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public DelphiException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public DelphiException(int code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeString() {
        return DelphiException.codeToString(this.code);
    }

    public String getBaseMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String base = super.getMessage();
        if (Strings.isNullOrEmpty((String)base)) {
            return String.format("Error %s (%s)", this.code, DelphiException.codeToString(this.code));
        }
        return String.format("Error %s (%s): %s", this.code, DelphiException.codeToString(this.code), base);
    }

    public static String codeToString(int code) {
        return switch (code) {
            case 1 -> "ERR_NO_SUCH_FILE";
            case 2 -> "ERR_ACCESS_DENIED";
            case 3 -> "ERR_IO_ERROR";
            case 4 -> "ERR_INVALID_PATH";
            case 5 -> "ERR_API_MODULE";
            case 6 -> "ERR_SYNTAX";
            case 7 -> "ERR_SCHEMA_ERROR";
            case 8 -> "ERR_SAX_PARSER_INIT_FAILED";
            case 9 -> "ERR_DOC_PARSE";
            case 10 -> "ERR_MISSING_PLUGINS";
            case 11 -> "ERR_MODULE_UNKNOWN";
            case 12 -> "ERR_MODULE_DIRECTORY_NOT_FOUND";
            case 13 -> "ERR_MODULE_ZIP_ACCESS_DENIED";
            case 14 -> "ERR_MODULE_ERROR";
            case 15 -> "ERR_EMPTY_MODULE_NAME";
            case 16 -> "ERR_INSTANCE_NAME_USED";
            case 17 -> "ERR_ILLEGAL_INSTANCE_NAME";
            case 18 -> "ERR_OLD_GAME_VERSION";
            default -> "ERR_UNKNOWN";
        };
    }
}

