/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.delphi.event;

import com.juliewoolie.delphi.DocumentView;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class DocumentViewMoveEvent
extends Event {
    private static final HandlerList handlerList = new HandlerList();
    private final DocumentView view;
    private final World world;
    private final Vector3d position;

    public DocumentViewMoveEvent(DocumentView view, World world, Vector3d position) {
        Objects.requireNonNull(view, "Null view");
        Objects.requireNonNull(world, "Null world");
        Objects.requireNonNull(position, "Null position");
        this.view = view;
        this.world = world;
        this.position = position;
    }

    @NotNull
    public DocumentView getView() {
        return this.view;
    }

    @NotNull
    public Location getNewLocation() {
        return new Location(this.world, this.position.x, this.position.y, this.position.z);
    }

    public World getWorld() {
        return this.world;
    }

    public Vector3d getPosition() {
        return new Vector3d((Vector3dc)this.position);
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlerList;
    }
}

