/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.dom.style;

import com.juliewoolie.dom.style.PrimitiveImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public sealed interface Primitive
permits PrimitiveImpl {
    public static final float DEGREES_IN_CIRCLE = 360.0f;
    public static final float GRADIANS_IN_CIRCLE = 400.0f;
    public static final Primitive ZERO = new PrimitiveImpl(0.0f, Unit.NONE);
    public static final Primitive ONE = new PrimitiveImpl(1.0f, Unit.NONE);
    public static final Primitive NAN = new PrimitiveImpl(Float.NaN, Unit.NONE);
    public static final Primitive INFINITY = new PrimitiveImpl(Float.POSITIVE_INFINITY, Unit.NONE);
    public static final Primitive NEGATIVE_INFINITY = new PrimitiveImpl(Float.NEGATIVE_INFINITY, Unit.NONE);

    public static Primitive create(float base, @NotNull Unit unit) {
        Objects.requireNonNull(unit, "Null unit");
        if (unit == Unit.NONE) {
            if (base == 0.0f) {
                return ZERO;
            }
            if (base == 1.0f) {
                return ONE;
            }
            if (Float.isNaN(base)) {
                return NAN;
            }
            if (base == Float.POSITIVE_INFINITY) {
                return INFINITY;
            }
            if (base == Float.NEGATIVE_INFINITY) {
                return NEGATIVE_INFINITY;
            }
        }
        return new PrimitiveImpl(base, unit);
    }

    public static Primitive create(float base) {
        return Primitive.create(base, Unit.NONE);
    }

    public float getValue();

    @NotNull
    public Unit getUnit();

    public boolean isZero();

    public float toDegrees();

    public static enum Unit {
        NONE(""),
        PX("px"),
        CH("ch"),
        VW("vw"),
        VH("vh"),
        M("m"),
        CM("cm"),
        PERCENT("%"),
        DEG("deg"),
        GRAD("grad"),
        RAD("rad"),
        TURN("turn");

        private final String unit;

        private Unit(String unit) {
            this.unit = unit;
        }

        public static Unit[] angleUnits() {
            return new Unit[]{DEG, GRAD, RAD, TURN, NONE};
        }

        public String getUnit() {
            return this.unit;
        }

        public String toString() {
            return this.unit;
        }
    }
}

