/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.dom.style;

import com.juliewoolie.dom.style.Primitive;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class PrimitiveImpl
implements Primitive {
    private final float value;
    private final Primitive.Unit unit;

    public PrimitiveImpl(float value, Primitive.Unit unit) {
        this.value = value;
        this.unit = Objects.requireNonNullElse(unit, Primitive.Unit.NONE);
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public Primitive.Unit getUnit() {
        return this.unit;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0f;
    }

    @Override
    public float toDegrees() {
        return switch (this.unit) {
            case Primitive.Unit.NONE, Primitive.Unit.DEG -> this.value;
            case Primitive.Unit.RAD -> (float)Math.toDegrees(this.value);
            case Primitive.Unit.TURN -> 360.0f * this.value;
            case Primitive.Unit.GRAD -> this.value / 400.0f * 360.0f;
            default -> 0.0f;
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimitiveImpl)) {
            return false;
        }
        PrimitiveImpl primitive = (PrimitiveImpl)o;
        return Float.compare(this.value, primitive.value) == 0 && this.unit == primitive.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.value), this.unit});
    }

    public String toString() {
        return this.value + this.unit.getUnit();
    }
}

