/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.dom;

import com.juliewoolie.dom.DomQueryable;
import com.juliewoolie.dom.Node;
import com.juliewoolie.dom.TextNode;
import com.juliewoolie.dom.event.EventTarget;
import com.juliewoolie.dom.style.StyleProperties;
import com.juliewoolie.dom.style.StylePropertiesReadonly;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Element
extends Node,
EventTarget,
DomQueryable {
    public StyleProperties getInlineStyle();

    public StylePropertiesReadonly getCurrentStyle();

    @Nullable
    public String getAttribute(String var1);

    @Contract(value="null -> false")
    public boolean hasAttribute(@Nullable String var1);

    public void setAttribute(@NotNull String var1, @Nullable String var2);

    @Nullable
    public String removeAttribute(String var1);

    public Set<String> getAttributeNames();

    public Set<Map.Entry<String, String>> getAttributeEntries();

    default public String getId() {
        return this.getAttribute("id");
    }

    default public void setId(@Nullable String elementId) {
        this.setAttribute("id", elementId);
    }

    @Nullable
    default public String getClassName() {
        return this.getAttribute("class");
    }

    default public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @NotNull
    public List<String> getClassList();

    public String getTagName();

    @Nullable
    public Node getTooltip();

    @Nullable
    public Node getTitleNode();

    public void setTitleNode(@Nullable Node var1);

    public void appendChild(@NotNull Node var1);

    public void prependChild(@NotNull Node var1);

    public void insertBefore(@NotNull Node var1, @NotNull Node var2);

    public void insertAfter(@NotNull Node var1, @NotNull Node var2);

    public void replaceChild(int var1, @NotNull Node var2);

    public void replaceChild(@NotNull Node var1, @NotNull Node var2);

    public boolean removeChild(@NotNull Node var1);

    public void removeChild(int var1) throws IndexOutOfBoundsException;

    public void removeMatchingChildren(@NotNull Predicate<Node> var1);

    public void clearChildren();

    public List<Node> getChildren();

    public boolean hasChildren();

    @Contract(value="null -> false")
    public boolean hasChild(@Nullable Node var1);

    public int indexOf(@Nullable Node var1);

    public int getChildCount();

    public boolean canHaveChildren();

    public Node getChild(int var1) throws IndexOutOfBoundsException;

    @Nullable
    public Node firstChild();

    @Nullable
    public Node lastChild();

    @NotNull
    default public Element appendElement(@NotNull String tagName) {
        Element el = this.getOwningDocument().createElement(tagName);
        this.appendChild(el);
        return el;
    }

    @NotNull
    default public TextNode appendText(@Nullable String text) {
        TextNode node = this.getOwningDocument().createText(text);
        this.appendChild(node);
        return node;
    }

    public String getTextContent();

    public void setTextContent(String var1);

    public void forEachDescendant(@NotNull Consumer<Node> var1);

    @Contract(value="null -> false")
    public boolean isDescendant(@Nullable Node var1);

    public boolean matches(String var1);
}

