/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.dom;

import com.google.common.base.Strings;
import com.juliewoolie.delphi.util.Result;
import org.jetbrains.annotations.Nullable;

public interface Attributes {
    public static final String ID = "id";
    public static final String CLASS = "class";
    public static final String STYLE = "style";
    public static final String SOURCE = "src";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String ENABLED = "enabled";
    public static final String ITEM_TOOLTIP_HIDE = "hide-item-tooltip";
    public static final String ADVANCED_ITEM_TOOLTIPS = "advanced-item-tooltips";
    public static final String BUTTON_ACTION = "action";
    public static final String ACTION_TRIGGER = "action-trigger";
    public static final String CLASS_NAME = "class-name";
    public static final String TYPE = "type";
    public static final String PLACEHOLDER = "placeholder";
    public static final String DEFER = "defer";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";

    public static Result<Float, String> floatAttribute(String value, float min, float max) {
        float f;
        try {
            f = Float.parseFloat(value);
        }
        catch (NumberFormatException exc) {
            return Result.err("Invalid number");
        }
        if (f < min) {
            return Result.ok(Float.valueOf(min));
        }
        if (f > max) {
            return Result.ok(Float.valueOf(max));
        }
        return Result.ok(Float.valueOf(f));
    }

    public static int intAttribute(String value, int min, int max, int fb) {
        if (Strings.isNullOrEmpty((String)value)) {
            return fb;
        }
        try {
            return Math.clamp((long)Integer.parseInt(value), min, max);
        }
        catch (NumberFormatException exc) {
            return fb;
        }
    }

    public static boolean boolAttribute(@Nullable String value, boolean fallback) {
        if (Strings.isNullOrEmpty((String)value)) {
            return fallback;
        }
        return switch (value.toLowerCase()) {
            case "true" -> true;
            case "false" -> false;
            default -> fallback;
        };
    }
}

