/*
 * Decompiled with CFR 0.152.
 */
package com.juliewoolie.dom.style;

import com.juliewoolie.dom.style.Color;
import com.juliewoolie.dom.style.NamedColor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

final class DelphiColor
implements Color {
    final byte alpha;
    final byte red;
    final byte green;
    final byte blue;

    public DelphiColor(int alpha, int red, int green, int blue) {
        this.validate(alpha, "Alpha");
        this.validate(red, "Red");
        this.validate(green, "Green");
        this.validate(blue, "Blue");
        this.alpha = (byte)alpha;
        this.red = (byte)red;
        this.green = (byte)green;
        this.blue = (byte)blue;
    }

    static Color blend(boolean hsv, float progress, Color ... colors) {
        if (colors.length == 0) {
            return null;
        }
        if (colors.length == 1) {
            return colors[0];
        }
        if (progress <= 0.0f) {
            return colors[0];
        }
        if (progress >= 1.0f) {
            return colors[colors.length - 1];
        }
        int max = colors.length - 1;
        int startIdx = (int)(progress * (float)max);
        float firstStep = (float)startIdx / (float)max;
        float localStep = (progress - firstStep) * (float)max;
        Color c1 = colors[startIdx];
        Color c2 = colors[startIdx + 1];
        if (hsv) {
            return c1.blendHsv(localStep, c2);
        }
        return c1.blendRgb(localStep, c2);
    }

    public static Color hsvaColor(float hue, float saturation, float value, float alpha) {
        int alphaInt = (int)(Math.clamp(alpha, 0.0f, 1.0f) * 255.0f);
        int argb = java.awt.Color.HSBtoRGB(hue, saturation, value);
        int rgb = argb & 0xFFFFFF;
        return Color.argb(rgb | alphaInt << 24);
    }

    private void validate(int v, String channel) {
        if (v >= 0 && v <= 255) {
            return;
        }
        throw new IllegalArgumentException(channel + " channel is out of bounds [0..255]: " + v);
    }

    @Override
    public int getAlpha() {
        return this.alpha & 0xFF;
    }

    @Override
    public int getRed() {
        return this.red & 0xFF;
    }

    @Override
    public int getGreen() {
        return this.green & 0xFF;
    }

    @Override
    public int getBlue() {
        return this.blue & 0xFF;
    }

    @Override
    public float @NotNull [] hsv() {
        return java.awt.Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
    }

    @Override
    public float @NotNull [] hsva() {
        float[] arr = new float[4];
        java.awt.Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), arr);
        arr[3] = (float)this.getAlpha() / 255.0f;
        return arr;
    }

    @Override
    public int argb() {
        return (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    @Override
    public int rgb() {
        return (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    @Override
    public String toString() {
        int argb = this.argb();
        String foundName = (String)NamedColor.VALUE_TO_NAME.get(argb);
        if (foundName != null) {
            return foundName;
        }
        return this.hexString();
    }

    @Override
    public String hexString() {
        String hex = this.getAlpha() == 255 ? this.toHex(this.rgb(), 6) : this.toHex(this.argb(), 8);
        return "#" + hex;
    }

    private String toHex(int v, int chars) {
        String hex = Integer.toUnsignedString(v, 16);
        if (hex.length() < chars) {
            return "0".repeat(chars - hex.length()) + hex;
        }
        return hex;
    }

    @Override
    @NotNull
    public Color brighten() {
        return this.brighten(0.25f);
    }

    @Override
    @NotNull
    public Color brighten(@Range(from=0L, to=1L) float amount) {
        amount = Math.clamp(amount, 0.0f, 1.0f);
        return this.mulAdd(amount);
    }

    private static int mulAddChannel(byte v, float mod) {
        int b32 = v & 0xFF;
        int mul = (int)(mod * 255.0f);
        return Math.clamp((long)(mul + b32), 0, 255);
    }

    @Override
    @NotNull
    public Color darken() {
        return this.darken(0.25f);
    }

    @Override
    @NotNull
    public Color darken(@Range(from=0L, to=1L) float amount) {
        amount = -Math.clamp(amount, 0.0f, 1.0f);
        return this.mulAdd(amount);
    }

    private Color mulAdd(float amount) {
        int r = DelphiColor.mulAddChannel(this.red, amount);
        int g = DelphiColor.mulAddChannel(this.green, amount);
        int b = DelphiColor.mulAddChannel(this.blue, amount);
        return Color.argb(this.getAlpha(), r, g, b);
    }

    @Override
    @NotNull
    public Color multiplyRgb(float multiplier) {
        return Color.argb(this.getAlpha(), DelphiColor.multiplyChannel(this.red, multiplier), DelphiColor.multiplyChannel(this.green, multiplier), DelphiColor.multiplyChannel(this.blue, multiplier));
    }

    @Override
    @NotNull
    public Color multiplyArgb(float multiplier) {
        return Color.argb(DelphiColor.multiplyChannel(this.alpha, multiplier), DelphiColor.multiplyChannel(this.red, multiplier), DelphiColor.multiplyChannel(this.green, multiplier), DelphiColor.multiplyChannel(this.blue, multiplier));
    }

    @Override
    @NotNull
    public Color multiplyHsv(float multiplier) {
        float[] hsv = this.hsv();
        for (int i = 0; i < hsv.length; ++i) {
            hsv[i] = Math.clamp(hsv[i] * multiplier, 0.0f, 1.0f);
        }
        int rgb = java.awt.Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]);
        return Color.argb(rgb & (this.alpha & 0xFF) << 24);
    }

    @Override
    @NotNull
    public Color multiplyHsv(float hue, float sat, float val) {
        float[] hsv = this.hsv();
        hsv[0] = hsv[0] * hue;
        hsv[1] = hsv[1] * sat;
        hsv[2] = hsv[2] * val;
        return DelphiColor.hsvaColor(hsv[0], hsv[1], hsv[2], (float)this.getAlpha() / 255.0f);
    }

    private static int multiplyChannel(byte c, float amount) {
        int b32 = c & 0xFF;
        int multiplied = (int)((float)b32 * amount);
        return Math.clamp((long)multiplied, 0, 255);
    }

    @Override
    @NotNull
    public Color blendRgb(float progress, @NotNull Color other) {
        if (progress <= 0.0f) {
            return this;
        }
        if (progress >= 1.0f) {
            return other;
        }
        DelphiColor o = (DelphiColor)other;
        return Color.argb(this.getAlpha(), DelphiColor.lerpChannel(this.red, o.red, progress), DelphiColor.lerpChannel(this.green, o.green, progress), DelphiColor.lerpChannel(this.blue, o.blue, progress));
    }

    private static int lerpChannel(byte sv, byte ov, float prog) {
        int s = sv & 0xFF;
        int o = ov & 0xFF;
        return (int)((float)s + (float)(o - s) * prog);
    }

    @Override
    @NotNull
    public Color blendHsv(float progress, @NotNull Color other) {
        if (progress <= 0.0f) {
            return this;
        }
        if (progress >= 1.0f) {
            return other;
        }
        float[] hsvThis = this.hsv();
        float[] hsvOther = other.hsv();
        float[] values = new float[hsvThis.length];
        for (int i = 0; i < hsvThis.length; ++i) {
            float s = hsvThis[i];
            float o = hsvOther[i];
            values[i] = s + (o - s) * progress;
        }
        int rgb = java.awt.Color.HSBtoRGB(values[0], values[1], values[2]);
        return Color.argb(rgb & (this.alpha & 0xFF) << 24);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DelphiColor)) {
            return false;
        }
        DelphiColor that = (DelphiColor)o;
        return this.alpha == that.alpha && this.red == that.red && this.green == that.green && this.blue == that.blue;
    }

    public int hashCode() {
        return Objects.hash(this.alpha, this.red, this.green, this.blue);
    }
}

